/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.statistics.IVWSIMStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMQueueStatTable;
import filenet.sim.toolkit.viewer.statistics.VWSIMQueueStatTableModel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsPanel;
import java.awt.Frame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMQueueStatPanel
extends JScrollPane
implements ChangeListener,
IVWSIMStatPanel {
    private VWSIMStatisticsPanel m_statisticsPanel = null;
    private VWSIMQueueStatTableModel m_tableModel = null;
    private VWSIMQueueStatTable m_table = null;
    private VWSIMAnimatorDataModel m_animatorDataModel = null;
    protected Frame m_parentFrame = null;

    VWSIMQueueStatPanel(Frame parentFrame, VWSIMStatisticsPanel statisticsPanel, VWSIMAnimatorDataModel animatorDataModel) {
        this.m_parentFrame = parentFrame;
        this.m_statisticsPanel = statisticsPanel;
        this.m_animatorDataModel = animatorDataModel;
    }

    public void initialize() {
        if (this.m_animatorDataModel == null || this.m_animatorDataModel.getInitState() != 6) {
            return;
        }
        this.m_tableModel = new VWSIMQueueStatTableModel(this.m_animatorDataModel);
        this.m_table = new VWSIMQueueStatTable(this.m_parentFrame, this, this.m_tableModel);
        this.m_tableModel.initData();
        this.add(this.m_table);
        this.setViewportView(this.m_table);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane && this.m_table != null) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (tabbedPane.getSelectedComponent() == this) {
                this.m_table.tabSelected(true);
            } else {
                this.m_table.tabSelected(false);
            }
        }
    }

    public void updateInfo() {
        this.m_tableModel.fireTableDataChanged();
    }

    public void releaseResources() {
        if (this.m_table != null) {
            this.m_table.releaseResources();
            this.m_table = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.m_statisticsPanel = null;
        this.m_animatorDataModel = null;
        this.m_parentFrame = null;
        this.removeAll();
    }
}

